"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeaderboardComponent = void 0;
var __selfType = requireType("./LeaderboardComponent");
function component(target) { target.getTypeName = function () { return __selfType; }; }
const Event_1 = require("./Modules/Event");
const FullLeaderboard_1 = require("./FullLeaderboard");
const DestructionHelper_1 = require("./DestructionHelper");
const ComponentUtils_1 = require("./ComponentUtils");
const LeaderboardRelated_1 = require("./Interfaces/LeaderboardRelated");
const CameraBadgeLeaderboard_1 = require("./CameraBadgeLeaderboard");
const LeaderboardConstants_1 = require("./Interfaces/LeaderboardConstants");
const LeaderboardUtils_1 = require("./LeaderboardUtils");
const ComponentWithDebug_1 = require("./Modules/ComponentWithDebug");
const BitmojiStickerLoader_1 = require("./BitmojiStickerLoader");
const CachedEvent_1 = require("./Modules/CachedEvent");
const DateUtils_1 = require("./Modules/DateUtils");
const TokenManager_1 = require("./TokenManager");
var UsersType = Leaderboard.UsersType;
var ScoreLifetimeSeconds;
(function (ScoreLifetimeSeconds) {
    ScoreLifetimeSeconds[ScoreLifetimeSeconds["Day"] = 86400] = "Day";
    ScoreLifetimeSeconds[ScoreLifetimeSeconds["Week"] = 604800] = "Week";
    ScoreLifetimeSeconds[ScoreLifetimeSeconds["Month"] = 2592000] = "Month";
    ScoreLifetimeSeconds[ScoreLifetimeSeconds["Year"] = 31104000] = "Year";
})(ScoreLifetimeSeconds || (ScoreLifetimeSeconds = {}));
const ScoreLifetimeOptionsToScoreLifetimeSeconds = {
    [LeaderboardRelated_1.ScoreResetIntervalOption.Day]: ScoreLifetimeSeconds.Day,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Week]: ScoreLifetimeSeconds.Week,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Month]: ScoreLifetimeSeconds.Month,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Year]: ScoreLifetimeSeconds.Year,
};
const ScoreLifetimeOptionsToResetString = {
    [LeaderboardRelated_1.ScoreResetIntervalOption.Day]: LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.DAILY_RESET_STRING,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Week]: LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.WEEKLY_RESET_STRING,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Month]: LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.MONTHLY_RESET_STRING,
    [LeaderboardRelated_1.ScoreResetIntervalOption.Year]: LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.YEARLY_RESET_STRING,
};
let LeaderboardComponent = class LeaderboardComponent extends ComponentWithDebug_1.ComponentWithDebug {
    onAwake() {
        this.createEvent("OnDestroyEvent").bind(() => {
            this.destructionHelper.destroyAll();
        });
        this.updateEvent = this.createEvent("UpdateEvent");
        this.updateEvent.enabled = false;
        this.updateEvent.bind(this.onUpdate);
        if (!this.isInputValid()) {
            return;
        }
        this.bitmojiStickerLoader = new BitmojiStickerLoader_1.BitmojiStickerLoader(this.bitmojiModule, this.remoteMediaModule);
        const dependenciesParent = this.componentDependencies.instantiate(this.getSceneObject().getParent());
        dependenciesParent.enabled = true;
        if (!this.isTweenJsPresent()) {
            return;
        }
        this.currentUserPromise = new Promise((resolve, reject) => {
            this.currentUserResolver = resolve;
        });
        this.currentUserBitmojiPromise = new Promise((resolve, reject) => {
            this.currentUserBitmojiResolver = resolve;
        });
        this.getLeaderboardPromise = new Promise((resolve, reject) => {
            this.getLeaderboardResolver = resolve;
            this.getLeaderboardRejecter = reject;
        });
        this.dependencies = dependenciesParent.getComponent("Component.ScriptComponent");
        this.dependencies.enabled = true;
        this.initializeSideSwitcher();
        this.adjustUserLimit();
        this.initializeLeaderboardVisuals();
        (0, ComponentUtils_1.setRenderOrderRecursivelyRelativeToParent)(this.getSceneObject(), this.renderOrder);
        (0, ComponentUtils_1.setRenderLayerRecursively)(this.getSceneObject(), this.getSceneObject().layer);
        this.scoreLifetimeSeconds = ScoreLifetimeOptionsToScoreLifetimeSeconds[this.scoreLifetimeOption];
        this.leaderboardVisualsControl.setFallbackEnabled(true);
        if (this.backgroundCustomization === LeaderboardRelated_1.BackgroundCustomization.Texture) {
            this.leaderboardVisualsControl.setCustomTextureHeader(this.backgroundTexture);
        }
        if (this.autoInitialize) {
            this.leaderboardVisualsControl.setTimerUiEnabled(true);
            this.createLeaderboard(this.collectParamsFromInput());
            this.leaderboardVisualsControl.setTimerText(ScoreLifetimeOptionsToResetString[this.scoreLifetimeOption]);
        }
    }
    get visible() {
        return this.isVisible;
    }
    submitScore(score) {
        this.printDebug("Submitting score " + score);
        if (!isNull(this.leaderboard)) {
            this.leaderboard.submitScore(score, this.onSubmitScoreSuccess, this.onSubmitScoreFailed);
        }
    }
    show() {
        this.leaderboardVisualsControl.show();
    }
    hide() {
        this.leaderboardVisualsControl.hide();
    }
    getSideSwitcher() {
        return this.dependencies.getSideSwitcher();
    }
    async getLeaderboard() {
        return this.getLeaderboardPromise;
    }
    async getCurrentUser() {
        return this.currentUserPromise;
    }
    async getCurrentUserBitmoji() {
        return this.currentUserBitmojiPromise;
    }
    initializeWithOptions(leaderboardInitializationOptions) {
        if (this.autoInitialize) {
            throw new Error("Please remove Auto Initialize from component inputs");
        }
        if (isNull(leaderboardInitializationOptions.userType) ||
            isNull(leaderboardInitializationOptions.scoreOrdering) ||
            isNull(leaderboardInitializationOptions.userLimit) ||
            isNull(leaderboardInitializationOptions.scoreResetInterval) ||
            isNull(leaderboardInitializationOptions.useTimer) ||
            isNull(leaderboardInitializationOptions.name)) {
            this.printWarning("LeaderboardInitializationOptions are incorrect");
            throw new Error("LeaderboardInitializationOptions are incorrect");
        }
        const isNameProvided = !isNull(leaderboardInitializationOptions.name);
        if (!leaderboardInitializationOptions.useTimer && !isNameProvided) {
            throw new Error("Please provide leaderboard name");
        }
        if (leaderboardInitializationOptions.useTimer && isNull(leaderboardInitializationOptions.leaderboardStartDate)) {
            throw new Error("Please provide leaderboard start date");
        }
        const ttlSeconds = ScoreLifetimeOptionsToScoreLifetimeSeconds[leaderboardInitializationOptions.scoreResetInterval];
        this.useTimer = leaderboardInitializationOptions.useTimer;
        if (this.useTimer) {
            this.leaderboardVisualsControl.setTimerText(ScoreLifetimeOptionsToResetString[leaderboardInitializationOptions.scoreResetInterval]);
        }
        const scoreOrdering = leaderboardInitializationOptions.scoreOrdering;
        const userType = leaderboardInitializationOptions.userType;
        const userLimit = !isNull(leaderboardInitializationOptions.userLimit) ? leaderboardInitializationOptions.userLimit : this.userLimit;
        const details = this.createNewLeaderboardDetails(leaderboardInitializationOptions.leaderboardStartDate, leaderboardInitializationOptions.name, ttlSeconds, leaderboardInitializationOptions.scoreResetInterval, scoreOrdering);
        const name = isNameProvided ? leaderboardInitializationOptions.name : details.leaderboardId;
        const leaderboardParams = {
            leaderboardName: name,
            ttlSeconds: ttlSeconds,
            scoreLifetimeOption: leaderboardInitializationOptions.scoreResetInterval,
            orderingType: scoreOrdering,
            userType: userType,
            userLimit: userLimit,
            leaderboardDetails: leaderboardInitializationOptions.useTimer ? details : null,
            leaderboardNamePrefix: leaderboardInitializationOptions.name
        };
        this.createLeaderboard(leaderboardParams);
    }
    setLeaderboardName(name) {
        if (!(this.leaderboardVisualsControl instanceof CameraBadgeLeaderboard_1.CameraBadgeLeaderboard)) {
            this.leaderboardVisualsControl.setLeaderboardName(name);
        }
    }
    createNewLeaderboardDetails(leaderboardStartDateString, leaderboardNamePrefix, scoreLifetimeSeconds, scoreLifetimeOption, scoreOrdering) {
        const currentDate = new Date();
        const scoreLifetimeMillis = scoreLifetimeSeconds * 1000;
        const parsedStartDate = new Date(Date.parse(leaderboardStartDateString));
        const offsetDateMillis = (Date.UTC(parsedStartDate.getFullYear(), parsedStartDate.getMonth(), parsedStartDate.getDate(), 0, 0, 0, 0));
        const leaderboardRelativeIndex = (0, DateUtils_1.getIdFromUTCTime)((0, DateUtils_1.getUTCTime)(currentDate), scoreLifetimeMillis, -offsetDateMillis);
        const leaderboardDetails = {
            currentDate: currentDate,
            offsetDateMillis: offsetDateMillis,
            leaderboardRelativeIndex: leaderboardRelativeIndex,
            leaderboardId: (0, DateUtils_1.constructLeaderboardId)(leaderboardNamePrefix, leaderboardStartDateString, leaderboardRelativeIndex.toString(), scoreLifetimeOption.toString(), scoreOrdering.toString()),
            timeToFinish: (0, DateUtils_1.getMilisecondsToFinish)(offsetDateMillis, scoreLifetimeMillis, leaderboardRelativeIndex, (0, DateUtils_1.getUTCTime)(currentDate)),
            leaderboardStartDate: leaderboardStartDateString,
        };
        return leaderboardDetails;
    }
    updateLeaderboardDetails() {
        const currentDate = new Date();
        if (isNull(this.leaderboardParams.leaderboardDetails)) {
            return;
        }
        const timeToFinishMs = (0, DateUtils_1.getMilisecondsToFinish)(this.leaderboardParams.leaderboardDetails.offsetDateMillis, this.leaderboardParams.ttlSeconds * 1000, this.leaderboardParams.leaderboardDetails.leaderboardRelativeIndex, (0, DateUtils_1.getUTCTime)(currentDate));
        if (timeToFinishMs <= 0) {
            this.reset();
            this.recreateLeaderboard();
            return;
        }
        this.leaderboardParams.leaderboardDetails.timeToFinish = timeToFinishMs;
        this.leaderboardVisualsControl.setTimeLeft(timeToFinishMs);
    }
    collectParamsFromInput() {
        const leaderboardDetails = this.createNewLeaderboardDetails(this.leaderboardStartDate, this.leaderboardName, this.scoreLifetimeSeconds, this.scoreLifetimeOption, this.scoreOrdering);
        return {
            leaderboardName: leaderboardDetails.leaderboardId,
            ttlSeconds: this.scoreLifetimeSeconds,
            scoreLifetimeOption: this.scoreLifetimeOption,
            orderingType: this.scoreOrdering,
            userType: this.userType,
            userLimit: this.userLimit,
            leaderboardDetails: leaderboardDetails,
            leaderboardNamePrefix: this.leaderboardName
        };
    }
    isTweenJsPresent() {
        if (!global.TWEEN || !global.TWEEN.Tween) {
            this.printWarning("Please add Tween Manager");
            return false;
        }
        return true;
    }
    initializeSideSwitcher() {
        const sideSwitcher = this.dependencies.getSideSwitcher();
        sideSwitcher.enableInteractable();
        sideSwitcher.onSwitch.add(() => {
            this.leaderboardVisualsControl.show();
            sideSwitcher.hide();
        });
        sideSwitcher.onHide.add(() => {
            if (sideSwitcher.tooltip) {
                sideSwitcher.tooltip.hide();
            }
        });
        (0, ComponentUtils_1.setRenderOrderRecursivelyRelativeToParent)(sideSwitcher.getSceneObject(), this.renderOrder + 1);
        (0, ComponentUtils_1.setRenderLayerRecursively)(sideSwitcher.getSceneObject(), this.getSceneObject().layer);
        this.applySideSwitcherDepthFix(sideSwitcher.getSceneObject());
    }
    applySideSwitcherDepthFix(sideSwitcherSo) {
        const interactions = (0, ComponentUtils_1.findSoWithComponent)(sideSwitcherSo, "Component.InteractionComponent");
        interactions.forEach((soWithInteraction) => {
            const screenTransform = soWithInteraction.getComponent("Component.ScreenTransform");
            if (!isNull(screenTransform)) {
                screenTransform.position = new vec3(screenTransform.position.x, screenTransform.position.y, 0);
            }
        });
    }
    initializeLeaderboardVisuals() {
        if (this.useCameraBadge) {
            this.initializeCameraBadge();
        }
        this.leaderboardVisualsControl = new FullLeaderboard_1.FullLeaderboard(this, this.leaderboardVisuals, this.leaderboardEntry, this.leaderboardEntryFallback, () => this.onLeaderboardClosed(), () => this.onLeaderboardOpened(), this.renderOrder, this.bitmojiStickerLoader, this.backgroundCustomization);
    }
    adjustUserLimit() {
        if (this.userType === UsersType.Friends) {
            if (this.userLimit > LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_FRIENDS) {
                this.printWarning("User limit was set to max value = " + LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_FRIENDS);
            }
            this.userLimit = MathUtils.clamp(this.userLimit, 0, LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_FRIENDS);
        }
        else if (this.userType === UsersType.Global) {
            if (this.userLimit > LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_GLOBAL) {
                this.printWarning("User limit was set to max value = " + LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_GLOBAL);
            }
            this.userLimit = MathUtils.clamp(this.userLimit, 0, LeaderboardConstants_1.LeaderboardConstants.Component.USER_LIMIT_GLOBAL);
        }
    }
    onLeaderboardClosed() {
        this.dependencies.getSideSwitcher().show();
        this.dependencies.getSideSwitcher().enableInteractable();
        this.isVisible = false;
        this.onHide.trigger();
    }
    onLeaderboardOpened() {
        this.isVisible = true;
        this.onShow.trigger();
    }
    createLeaderboard(leaderboardParameters) {
        if (this.leaderboardParams !== null && this.leaderboardParams.token) {
            this.tokenManager.dismissToken(this.leaderboardParams.token);
        }
        const newToken = this.tokenManager.generateToken();
        leaderboardParameters.token = newToken;
        this.leaderboardParams = leaderboardParameters;
        this.leaderboardVisualsControl.setIsGlobalLeaderboard(leaderboardParameters.userType === UsersType.Global);
        const leaderboardCreateOptions = Leaderboard.CreateOptions.create();
        leaderboardCreateOptions.name = leaderboardParameters.leaderboardName;
        leaderboardCreateOptions.ttlSeconds = leaderboardParameters.ttlSeconds;
        leaderboardCreateOptions.orderingType = leaderboardParameters.orderingType;
        this.leaderboardModule.getLeaderboard(leaderboardCreateOptions, (leaderboard) => {
            if (!this.tokenManager.isTokenValid(newToken)) {
                return;
            }
            this.printDebug("Leaderboard retrieved!");
            const retrievalOptions = this.createLeaderboardRetrievalOption(leaderboardParameters);
            this.leaderboard = leaderboard;
            this.getLeaderboardResolver(leaderboard);
            this.leaderboard.getLeaderboardInfo(retrievalOptions, (p1, p2) => this.onLeaderboardInfoRetrievedSuccesfull(p1, p2, newToken), this.onLeaderboardInfoRetrievedFailed);
        }, () => {
            this.getLeaderboardRejecter();
            this.printWarning("Leaderboard retrieval failed");
            this.leaderboardVisualsControl.setFallbackEnabled(true);
        });
        this.updateEvent.enabled = true;
    }
    addEntriesIfDoesntExist(leaderboardRecords, currentUserRecord) {
        for (let i = 0; i < leaderboardRecords.length; i++) {
            let isEntryKnown = false;
            for (let j = 0; j < this.allMergedRecords.length; j++) {
                if ((0, LeaderboardUtils_1.isSameUserEntry)(this.allMergedRecords[j], leaderboardRecords[i])) {
                    this.allMergedRecords[j] = leaderboardRecords[i];
                    isEntryKnown = true;
                    break;
                }
            }
            if (!isEntryKnown) {
                this.allMergedRecords.push(leaderboardRecords[i]);
            }
        }
        if (!isNull(currentUserRecord)) {
            let isCurrentUserInRecords = false;
            for (let i = 0; i < this.allMergedRecords.length; i++) {
                if ((0, LeaderboardUtils_1.isSameUserEntry)(this.allMergedRecords[i], currentUserRecord)) {
                    isCurrentUserInRecords = true;
                    this.allMergedRecords[i] = currentUserRecord;
                    break;
                }
            }
            if (!isCurrentUserInRecords) {
                this.allMergedRecords.push(currentUserRecord);
            }
        }
    }
    sortByScore(leaderboardRecords, orderingType) {
        const compareFn = orderingType === Leaderboard.OrderingType.Descending ?
            (a, b) => b.score - a.score : (a, b) => a.score - b.score;
        leaderboardRecords.sort(compareFn);
        if (this.leaderboardParams.userType === UsersType.Global) {
            const compareFnGlobalRank = (a, b) => a.globalExactRank - b.globalExactRank;
            leaderboardRecords.sort(compareFnGlobalRank);
        }
    }
    initializeCameraBadge() {
        this.cameraBadgeLeaderboard = new CameraBadgeLeaderboard_1.CameraBadgeLeaderboard(this, this.cameraBadgePrefab, this.renderOrder);
        this.dependencies.getSideSwitcher().onShow.add(() => {
            this.cameraBadgeLeaderboard.show();
        });
        this.dependencies.getSideSwitcher().onHide.add(() => {
            this.cameraBadgeLeaderboard.hide();
        });
    }
    loadBitmojiIfNotLoaded() {
        if (!isNull(this.userBitmojiTexture)) {
            return;
        }
        if (isNull(this.currentUserRecord) || isNull(this.currentUserRecord.snapchatUser)) {
            this.printDebug("Cannot load bitmoji");
            return;
        }
        const currentUser = this.currentUserRecord.snapchatUser;
        const hasBitmoji = !isNull(this.currentUserRecord.snapchatUser) &&
            !isNull(this.currentUserRecord.snapchatUser.hasBitmoji) && this.currentUserRecord.snapchatUser.hasBitmoji;
        if (!hasBitmoji) {
            return;
        }
        const onTextureReceived = (texture) => {
            this.currentUserBitmojiResolver(texture);
            this.userBitmojiTexture = texture;
            if (this.backgroundCustomization === LeaderboardRelated_1.BackgroundCustomization.Bitmoji && hasBitmoji) {
                this.leaderboardVisualsControl.setBitmoji(texture);
            }
            if (this.useCameraBadge && hasBitmoji) {
                this.cameraBadgeLeaderboard.setBitmoji(texture);
            }
        };
        const stickerId = (this.customStickerId && this.backgroundCustomization === LeaderboardRelated_1.BackgroundCustomization.Bitmoji)
            ? this.customStickerId : '';
        this.bitmojiStickerLoader.loadForUser(currentUser, stickerId)
            .then(onTextureReceived)
            .catch((e) => {
            this.printDebug("Error loading bitmoji");
        });
    }
    onCurrentUserRecordUpdated(currentUserRecord) {
        if (isNull(currentUserRecord)) {
            return;
        }
        this.currentUserRecord = currentUserRecord;
        this.loadBitmojiIfNotLoaded();
        this.addEntriesIfDoesntExist([], currentUserRecord);
        this.sortByScore(this.allMergedRecords, this.leaderboardParams.orderingType);
    }
    updateScoresState() {
        this.onLeaderboardRecordsUpdated.trigger({
            userRecords: this.allMergedRecords, currentUserRecord: this.currentUserRecord
        });
        if (!isNull(this.currentUserRecord) && !isNull(this.currentUserRecord.snapchatUser)) {
            this.currentUserResolver(this.currentUserRecord.snapchatUser);
        }
        this.leaderboardVisualsControl.visualiseEntries(this.allMergedRecords, this.currentUserRecord);
        if (this.useCameraBadge) {
            this.cameraBadgeLeaderboard.visualiseEntries(this.allMergedRecords, this.currentUserRecord);
        }
    }
    createLeaderboardRetrievalOption(leaderboardParameters) {
        const leaderboardRetrievalOption = Leaderboard.RetrievalOptions.create();
        leaderboardRetrievalOption.usersLimit = leaderboardParameters.userLimit;
        leaderboardRetrievalOption.usersType = leaderboardParameters.userType;
        return leaderboardRetrievalOption;
    }
    validateCamera() {
        const camera = (0, ComponentUtils_1.findParentComponent)(this.getSceneObject(), 'Camera');
        if (isNull(camera) || camera.type !== Camera.Type.Orthographic) {
            return false;
        }
        return true;
    }
    isInputValid() {
        if (this.leaderboardName === "") {
            this.printWarning("Please set leaderboard name. Important: changing leaderboard name will reset scores");
            return false;
        }
        if (isNull(this.getSceneObject().getParent()) || !this.validateCamera()) {
            this.printWarning("Please place Leaderboard under the Orthographic Camera");
            return false;
        }
        if (!(0, DateUtils_1.isDateStringValid)(this.leaderboardStartDate)) {
            this.printWarning("Please set correct date format, for example 31/12/2024");
            return false;
        }
        return true;
    }
    reset() {
        this.currentUserRecord = null;
        this.allMergedRecords = [];
    }
    recreateLeaderboard() {
        this.leaderboardParams.leaderboardDetails = this.createNewLeaderboardDetails(this.leaderboardParams.leaderboardDetails.leaderboardStartDate, this.leaderboardParams.leaderboardNamePrefix, this.leaderboardParams.ttlSeconds, this.leaderboardParams.scoreLifetimeOption, this.leaderboardParams.orderingType);
        this.leaderboardParams.leaderboardName = this.leaderboardParams.leaderboardDetails.leaderboardId;
        this.leaderboardVisualsControl.reset();
        this.createLeaderboard(this.leaderboardParams);
    }
    __initialize() {
        super.__initialize();
        this.ScoreResetIntervalOption = LeaderboardRelated_1.ScoreResetIntervalOption;
        this.onLeaderboardRecordsUpdated = new CachedEvent_1.CachedEvent();
        this.onShow = new Event_1.Event();
        this.onHide = new Event_1.Event();
        this.userType = Leaderboard.UsersType.Friends;
        this.destructionHelper = new DestructionHelper_1.DestructionHelper();
        this.screenTransform = (0, ComponentUtils_1.getOrCreateScreenTransform)(this.getSceneObject(), this.destructionHelper);
        this.isVisible = false;
        this.leaderboard = null;
        this.dependencies = null;
        this.userBitmojiTexture = null;
        this.currentUserRecord = null;
        this.allMergedRecords = [];
        this.useTimer = true;
        this.leaderboardParams = null;
        this.updateEvent = null;
        this.tokenManager = new TokenManager_1.TokenManager();
        this.onSubmitScoreSuccess = (currentUserRecord) => {
            this.printDebug("onSubmitScoreSuccess");
            this.onCurrentUserRecordUpdated(currentUserRecord);
            this.updateScoresState();
        };
        this.onSubmitScoreFailed = (status) => {
            this.printDebug("onSubmitScoreFailed");
        };
        this.onLeaderboardInfoRetrievedSuccesfull = (otherRecords, currentUserRecord, token) => {
            if (!this.tokenManager.isTokenValid(token)) {
                return;
            }
            this.onCurrentUserRecordUpdated(currentUserRecord);
            this.addEntriesIfDoesntExist(otherRecords, currentUserRecord);
            this.sortByScore(this.allMergedRecords, this.leaderboardParams.orderingType);
            this.updateScoresState();
        };
        this.onLeaderboardInfoRetrievedFailed = (status) => {
            this.printDebug("Failed to retrieve scores. Status = " + status);
            this.leaderboardVisualsControl.setFallbackEnabled(true);
        };
        this.onUpdate = () => {
            this.updateLeaderboardDetails();
            this.leaderboardVisualsControl.setTimerUiEnabled(this.useTimer);
        };
    }
};
exports.LeaderboardComponent = LeaderboardComponent;
exports.LeaderboardComponent = LeaderboardComponent = __decorate([
    component
], LeaderboardComponent);
//# sourceMappingURL=LeaderboardComponent.js.map